import java.awt.event.*;

class KlickEmpfaenger implements ActionListener{
  private Buecherliste bl;
  DatabaseConnector dbcAusleihe, dbcAG;     
  List<Leser> listeTeilnehmer;
  List<Buch> buchListe;
  Leser neuLeser;
  
  public KlickEmpfaenger(Buecherliste d){
    bl=d;
    dbcAusleihe=new DatabaseConnector("127.0.0.1", 3306,"./lib/BIB.db", "", "");     
    if (dbcAusleihe.getErrorMessage () == null) {
      System.out.println("Datenbank Ausleihe geoeffnet");
    } else {
      System.out.println(dbcAusleihe.getErrorMessage ()+"DatenbanÖffnung fehlgeschlagen");
    }  
    dbcAG=new DatabaseConnector("127.0.0.1", 3306,"./lib/AGVerwaltung.db", "", "");
    if (dbcAG.getErrorMessage () == null) {
      System.out.println("Datenbank AG geoeffnet");
    } else {
      System.out.println(dbcAG.getErrorMessage ()+"DatenbanÖffnung fehlgeschlagen");
    }    
  }
  
  public void beenden(){
    dbcAusleihe.close();
    dbcAG.close();
    bl.schliesseDatenbankverbindungundProgramm();
    
  }
  
  public List<Leser> ermittleTeilnehmer(String ag){
    List<Leser> li; 
    dbcAG.executeStatement("SELECT Nachname, Vorname, Klasse FROM Mitglied, besucht WHERE Mitglied.SchuelerNr=besucht.SchuelerNr AND AGName='"+ag+"'");
    QueryResult q=dbcAG.getCurrentQueryResult();
    String[][] daten=q.getData();
    String f=dbcAG.getErrorMessage();
    if (f!=null) {
      System.out.println(f);
    } // end of if        
    li=new List<Leser>();
    for(int i=0; i<q.getRowCount();i++){
      neuLeser=new Leser(daten[i][0],daten[i][1], daten[i][2]);
      li.append(neuLeser);
    }
    return li;
  }
  
  public List<Buch> geleseneBuecherVon(List<Leser> li){
    List<Buch> buchLi;
    buchLi=new List<Buch>();     
    Leser aktLeser;
    li.toFirst();
    while ( li.hasAccess()) { 
      aktLeser=li.getContent();        
      dbcAusleihe.executeStatement("SELECT DISTINCT titel, verfasser FROM Leser, Ausleihe, Exemplar,Band WHERE Leser.nachname='"+aktLeser.nachname()+ "' AND Leser.vorname='"+aktLeser.vorname()+"' AND Leser.klasse='"+aktLeser.klasse()+"' AND Leser.benutzer_id=ausleihe.benutzer_id AND ausleihe.exemplar_id=exemplar.exemplar_id AND exemplar.band_id=band.band_id" );
      QueryResult q2=dbcAusleihe.getCurrentQueryResult();
      String[][] daten=q2.getData();
      String f=dbcAusleihe.getErrorMessage();
      if (f!=null) {
        System.out.println(f);
      }  
      for(int i=0; i<q2.getRowCount();i++){
          buchLi.toFirst();
          while (buchLi.hasAccess()&&(!buchLi.getContent().titel().equals(daten[i][0])||!buchLi.getContent().autor().equals(daten[i][1]))) { 
            buchLi.next();
          } // end of while
          if (buchLi.hasAccess()) {              
            buchLi.getContent().erhoehe();               
          } // end of if
          else{
            Buch neuBuch=new Buch(daten[i][0],daten[i][1]);
            neuBuch.erhoehe();
            buchLi.append(neuBuch);                    
          }     
        } 
        li.next();      
      }  
      buchLi.toFirst();
      
      return buchLi;
    }
    
    
    public void actionPerformed(ActionEvent e) {
      if(e.getActionCommand().equals("Ende")){
        beenden();
      }          
      if (e.getActionCommand().equals("Buecher anzeigen")){
        if (bl.aktAG()!=null) {
          List<Leser> leser= ermittleTeilnehmer(bl.aktAG());
          leser.toFirst();
          while(leser.hasAccess()){
            leser.next(); 
          }                    
          
          bl.zeigeBuchListe(geleseneBuecherVon(leser));
        } // end of if
        
      }
    }
  }
